/*
 * Created on Jul 8, 2003
 */
package Validators;
import nz.co.k.tms.ldap.*;
import XmlCommunication.*;

import Data.*;

/**
 * This class is being used for validating Login data
 * 
 */
public class LoginValidator {

	private String message;
	//private XmlUnmarshal xmlunmarshal;

	/**
	 * This method is being used to get the validation message
	 * @return String message
	 */
	public String getMessage() {
		return message;
	}
	/**
	 * This method is being used setting validation message
	 * @param String message 
	 * @return void
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * This method is being used to validate login data
	 * @param announcementData data to be validated
	 * @return boolean true if validation successful
	 */
	public boolean validate(UserData userData) {

		UserData userdata = userData;
		String password, userName;

		password = userdata.getPassword();
		userName = userdata.getLoginId();
		System.out.println(userName + " " + password);
		if (password == null || userName == null) {
			message = "Either password or username is blank.";
			return false;
		} else {
			UserDetail ud ;
			try {
				 ud =
					LdapHelper.authentiacteUser(
						userData.getLoginId(),
						userData.getPassword());
				// Get ncb id ..
						String ncbid =
						XmlUnmarshal.readNcbServiceResponse(ud.getXmlPacket());
						int id = Integer.parseInt(ncbid);
					System.out.println(id);
					//Fetch user details.
					userdata.setNcbId(id);
			} catch (Exception e) {
				message =
					"Either password is incorrect or user does not exist.";
				return false;
			}
		}

		return true;
	}
}

